/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import replicatorg.app.Base;
import replicatorg.plugin.PluginEntry;

public class PluginLoader {
    static PluginLoader instance = new PluginLoader();

    private PluginLoader() {
    }

    public PluginLoader getInstance() {
        return instance;
    }

    private Vector<File> getCandidateJars() {
        Vector<File> candidates = new Vector<File>();
        File dir = new File(Base.getUserDirectory(), "plugins");
        if (dir.isDirectory()) {
            String[] names;
            String[] stringArray = names = dir.list();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.endsWith(".jar")) {
                    candidates.add(new File(dir, name));
                }
                ++n2;
            }
        }
        return candidates;
    }

    public Vector<PluginEntry> loadPlugins() {
        Vector<PluginEntry> plugins = new Vector<PluginEntry>();
        for (File f : this.getCandidateJars()) {
            if (!f.isFile()) continue;
            try {
                JarFile jar = new JarFile(f);
                ZipEntry entry = jar.getEntry("plugin.properties");
                if (entry == null || entry.isDirectory()) continue;
                InputStream is = jar.getInputStream(entry);
                Properties props = new Properties();
                props.load(is);
                String className = props.getProperty("plugin.class");
                String name = props.getProperty("plugin.name");
                String description = props.getProperty("plugin.description");
                is.close();
                jar.close();
                if (className == null || className.length() == 0 || name == null || name.length() == 0) {
                    System.err.println("Malformed plugin.properties found in " + f.getName());
                    continue;
                }
                URL[] urls = new URL[]{f.toURI().toURL()};
                URLClassLoader cl = new URLClassLoader(urls);
                try {
                    Class<?> c = cl.loadClass(className.trim());
                    Object o = c.newInstance();
                    plugins.add(new PluginEntry(name, description, o));
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Could not find class " + className + " in " + f.getName());
                }
                catch (InstantiationException e) {
                    System.err.println("Could not instantiate " + className);
                }
                catch (IllegalAccessException e) {
                    System.err.println("Could not instantiate " + className);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return plugins;
    }
}

